import { Component, OnInit, Input } from '@angular/core';
import { ConceptServices } from '../../../../services/concept-services';

@Component({
  selector: 'app-concept-card-metadata-mapping-data-elements-item',
  templateUrl: './concept-card-metadata-mapping-data-elements-item.component.html',
  styleUrls: ['./concept-card-metadata-mapping-data-elements-item.component.scss']
})
export class ConceptCardMetadataMappingDataElementsItemComponent implements OnInit {
  @Input() dataElementObj;
  mouseOvered: boolean;
  constructor(
    private conceptServices: ConceptServices) { }

  ngOnInit() {
  }

  getValueName(uri){
    if (uri !== null && uri.length > 0) {
      return uri.substr(uri.indexOf("#") + 1);
    } else {
      return null;
    }
  }

  accessConceptFromOntology(object) {
    if (object.value !== null) {
      this.conceptServices.getConcept(object.value);
    }
  }

}
